using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class IMAGE_ANALYSISDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public IMAGE_ANALYSISDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public IMAGE_ANALYSIS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 IMAGE_ANALYSIS_ID)
		{
			IMAGE_ANALYSIS objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_IMAGE_ANALYSIS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, IMAGE_ANALYSIS_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public IMAGE_ANALYSIS GetItemByPatientIcn(string CURRENT_USER, int CURRENT_REGISTRY_ID, string PATIENT_ICN)
        {
            IMAGE_ANALYSIS objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_IMAGE_ANALYSIS_getitemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ICN).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<IMAGE_ANALYSIS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<IMAGE_ANALYSIS> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_IMAGE_ANALYSIS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, IMAGE_ANALYSIS objSave)
		{
			Int32? objReturn = objSave.IMAGE_ANALYSIS_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_IMAGE_ANALYSIS_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BONE_FRACTURE_DOCUMENTED_FLAG, DateTime.Now, objSave.CREATEDBY, objSave.DATE_REVIEWED, objSave.FRAGMENT_VERIFIED_FLAG, objSave.FRAGMENTS_IN_JOIN_SPACE_FLAG, objSave.HAS_IMAGE_STUDIES_FLAG, ref objReturn, objSave.IMAGES_IN_CPRS_FLAG, objSave.JOINT_SPACE, objSave.OTHER_OBSERVATIONS, objSave.PATIENT_ID, objSave.STD_IMAGE_FRAGMENT_SIZE_ID, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 IMAGE_ANALYSIS_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_IMAGE_ANALYSIS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, IMAGE_ANALYSIS_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        #endregion
    }
}
